<?php ($currentUser= get_current_comment_user()); ?>
<?php ($commentable = $currentUser->authenticated || get_buzzy_config('COMMENTS_GUEST_COMMENT', true)); ?>
<form action="#" method="post" data-prepend="<?php echo e(isset($parent_id) ? 'no' : 'yes'); ?>"
    onsubmit="return false;" onSubmit="return false;">
    <?php if(isset($parent_id)): ?>
    <input type="hidden" name="parent_id" value="<?php echo e($parent_id); ?>">
    <?php endif; ?>
    <div class="loader-ajax"></div>
    <div class="add-comment-container">
        <img src="<?php echo e($currentUser->icon); ?>" alt="<?php echo e($currentUser->icon); ?>" class="usericont" />
        <div class="add-comment-form">
            <div>
                <textarea <?php if($commentable): ?> class="comment_text" <?php else: ?> data-href="<?php echo e(route('login')); ?>" rel="get:Loginform" <?php endif; ?>
                    name="comment_text" cols="30" rows="10"
                    placeholder="<?php echo e($commentable ? isset($parent_id) ? __("Reply to this comment.") : __('Share your thoughts about this.') : __("You must have to login to post a comment.")); ?>"></textarea>

                <div class="add-comment-form-actions">
                    <button type="submit" class="add_new_comment">
                        <div class="add-comment-loading"><img src="<?php echo e(asset('assets/images/ajax-loader.gif')); ?>"></div>
                        <span><?php echo e(isset($parent_id) ? __('Reply') : __('Comment')); ?></span>
                    </button>

                    <div class="add-comment-action-inputs">
                        <?php if(!$currentUser->authenticated && get_buzzy_config('COMMENTS_GUEST_COMMENT', true)): ?>
                          <div class="add-comment-action-guest-inputs">
                            <span class="add-comment-action-input"><input type="text" name="user_username" placeholder="<?php echo e(__('Your Name')); ?>"></span>
                            <span class="add-comment-action-input"><input type="text" name="user_email" placeholder="<?php echo e(__('Email')); ?>"></span>
                            <?php if(get_buzzy_config('BuzzyGuestCommentCaptcha')=="on" && get_buzzy_config('reCaptchaKey') !== ''): ?>
                            <span class="add-comment-action-input">
                                <script src='https://www.google.com/recaptcha/api.js' async defer></script>
                                <div class="g-recaptcha clearfix" data-sitekey="<?php echo e(get_buzzy_config('reCaptchaKey')); ?>"></div>
                            </span>
                            <?php endif; ?>
                            </div>
                        <?php endif; ?>
                        <?php if(get_buzzy_config('COMMENTS_USE_SPOILER_COMMENT', false)): ?>
                            <?php ($cid = uniqid()); ?>
                            <div class="add-comment-action-spoiler-input cd-form">
                                <input id="<?php echo e($cid); ?>" name="spoiler" type="checkbox">
                                <label for="<?php echo e($cid); ?>"><?php echo e(__('This comment contains spoilers?')); ?></label>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
<?php /**PATH /home/highaltitude/public_html/resources/views/comments/pages/_add_comment_form.blade.php ENDPATH**/ ?>