<div class="row">
    <div class="col-sm-12  col-md-8 col-lg-6">
        <div class="panel panel-primary">
            <div class="panel-heading"><?php echo e(trans('admin.OptionalConfigurations')); ?></div>
            <div class="panel-body no-padding">

<div class="nav-tabs-custom">
<ul class="nav nav-tabs">
<li class="active"><a href="#general-setting" data-toggle="tab"><?php echo e(__('General')); ?></a></li>
<li><a href="#post-setting" data-toggle="tab"><?php echo e(__('Post')); ?></a></li>
<li><a href="#editor-setting" data-toggle="tab"><?php echo e(__('Post Editor')); ?></a></li>
<li><a href="#home-setting" data-toggle="tab"><?php echo e(__('Home')); ?></a></li>
<li><a href="#rss-setting" data-toggle="tab"><?php echo e(__('RSS')); ?></a></li>
</ul>
<div class="tab-content">

<div class="tab-pane active" id="general-setting">
    <div class="form-group">
        <label class="control-label"><?php echo e(__('Disable Registration?')); ?></label>
        <?php echo Form::select('DisableRegister', ['yes' => trans('admin.yes'), 'no' => trans('admin.no')],
        get_buzzy_config('DisableRegister', 'no'), ['class' => 'form-control']); ?>

    </div>
    <div class="form-group">
        <label class="control-label"><?php echo e(__('Disable Login Icon on Header?')); ?></label>
        <?php echo Form::select('DisableLoginIcon', ['yes' => trans('admin.yes'), 'no' => trans('admin.no')],
        get_buzzy_config('DisableLoginIcon', 'no'), ['class' => 'form-control']); ?>

    </div>
    <div class="form-group">
        <label class="control-label"><?php echo e(__('Disable Create Button on Header?')); ?></label>
        <?php echo Form::select('DisableCreateButton', ['yes' => trans('admin.yes'), 'no' => trans('admin.no')],
        get_buzzy_config('DisableCreateButton', 'no'), ['class' => 'form-control']); ?>

    </div>
    <div class="form-group">
        <label class="control-label"><?php echo e(__('Disable Search Icon on Header?')); ?></label>
        <?php echo Form::select('DisableSearchIcon', ['yes' => trans('admin.yes'), 'no' => trans('admin.no')],
        get_buzzy_config('DisableSearchIcon', 'no'), ['class' => 'form-control']); ?>

    </div>
    <div class="form-group">
        <label class="control-label"><?php echo e(__('Disable Viral Menu on Main Menu?')); ?></label>
        <?php echo Form::select('DisableViralMenu', ['yes' => trans('admin.yes'), 'no' => trans('admin.no')],
        get_buzzy_config('DisableViralMenu', 'no'), ['class' => 'form-control']); ?>

        <span class="help-block"><?php echo e(__('Here you can disable the three dots dropdown menu')); ?></span>
    </div>
    <div class="form-group">
        <label class="control-label"><?php echo e(__('Disable Language Picker?')); ?></label>
        <?php echo Form::select('DisableLanguagePicker', ['yes' => trans('admin.yes'), 'no' => trans('admin.no')],
        get_buzzy_config('DisableLanguagePicker', 'no'), ['class' => 'form-control']); ?>

    </div>
</div>

<div class="tab-pane" id="home-setting">
    <div class="form-group">
        <label class="control-label"><?php echo e(trans('admin.Auto-listedonHomepage')); ?></label>
        <?php echo Form::select('AutoInHomepage', ['yes' => trans('admin.on'), 'no' => trans('admin.off')],
        get_buzzy_config('AutoInHomepage'), ['class' => 'form-control']); ?>

        <span class="help-block"><?php echo e(trans('admin.Auto-listedonHomepagehelp')); ?></span>
    </div>
</div>

<div class="tab-pane" id="post-setting">
     <div class="form-group">
        <label>
            <?php echo e(trans('admin.SitePostsUrlType')); ?>

        </label>
        <?php echo Form::select('siteposturl', [
        '1' => 'yoursite.com/{category}/{slug} (Default)',
        '2' => 'yoursite.com/{category}/{id}',
        '3' => 'yoursite.com/{username}/{slug}',
        '4' => 'yoursite.com/{username}/{id}',
        '5' => 'yoursite.com/{category}/{slug}-{id}'
        ], get_buzzy_config('siteposturl'), ['class' => 'form-control']); ?>

        <span class="help-block"><?php echo e(trans('admin.SitePostsUrlTypehelp')); ?></span>
    </div>
    <hr>
    <div class="form-group">
        <label class="control-label"><?php echo e(__('Show Categories on Post page?')); ?></label>
        <?php echo Form::select('ShowCategories', ['yes' => trans('admin.yes'), 'no' => trans('admin.no')],
        get_buzzy_config('ShowCategories', 'yes'), ['class' => 'form-control']); ?>

    </div>
    <div class="form-group">
        <label class="control-label"><?php echo e(__('Show Badges on Post page?')); ?></label>
        <?php echo Form::select('ShowBadges', ['yes' => trans('admin.yes'), 'no' => trans('admin.no')],
        get_buzzy_config('ShowBadges', 'yes'), ['class' => 'form-control']); ?>

    </div>
    <div class="form-group">
        <label class="control-label"><?php echo e(__('Show Featured Image on Post page?')); ?></label>
        <?php echo Form::select('ShowFeaturedImage', ['yes' => trans('admin.yes'), 'no' => trans('admin.no')],
        get_buzzy_config('ShowFeaturedImage', 'yes'), ['class' => 'form-control']); ?>

    </div>
    <div class="form-group">
        <label class="control-label"><?php echo e(__('Show Share Icons on Post page?')); ?></label>
        <?php echo Form::select('ShowShareIcons', ['yes' => trans('admin.yes'), 'no' => trans('admin.no')],
        get_buzzy_config('ShowShareIcons', 'yes'), ['class' => 'form-control']); ?>

    </div>
    <div class="form-group">
        <label class="control-label"><?php echo e(__('Show Font Sizer on Post page?')); ?></label>
        <?php echo Form::select('ShowFontSizer', ['yes' => trans('admin.yes'), 'no' => trans('admin.no')],
        get_buzzy_config('ShowFontSizer', 'yes'), ['class' => 'form-control']); ?>

    </div>
    <hr>
    <div class="form-group">
        <label class="control-label"><?php echo e(__('Show Author on Post page?')); ?></label>
        <?php echo Form::select('ShowAuthor', ['yes' => trans('admin.yes'), 'no' => trans('admin.no')],
        get_buzzy_config('ShowAuthor', 'yes'), ['class' => 'form-control', 'data-dependecy' => 'ShowAuthor']); ?>

    </div>
    <div class="form-group" data-target="ShowAuthor" data-value="yes">
        <label class="control-label"><?php echo e(__('Show Author Badge on Post page?')); ?></label>
        <?php echo Form::select('ShowAuthorBadge', ['yes' => trans('admin.yes'), 'no' => trans('admin.no')],
        get_buzzy_config('ShowAuthorBadge', 'yes'), ['class' => 'form-control']); ?>

    </div>
    <div class="form-group" data-target="ShowAuthor" data-value="yes">
        <label class="control-label"><?php echo e(__('Show Publish Date on Post page?')); ?></label>
        <?php echo Form::select('ShowPublishDate', ['yes' => trans('admin.yes'), 'no' => trans('admin.no')],
        get_buzzy_config('ShowPublishDate', 'yes'), ['class' => 'form-control']); ?>

    </div>
    <div class="form-group" data-target="ShowAuthor" data-value="yes">
        <label class="control-label"><?php echo e(__('Show Updated Date on Post page?')); ?></label>
        <?php echo Form::select('ShowUpdateDate', ['yes' => trans('admin.yes'), 'no' => trans('admin.no')],
        get_buzzy_config('ShowUpdateDate', 'yes'), ['class' => 'form-control']); ?>

    </div>
    <div class="form-group" data-target="ShowAuthor" data-value="yes">
        <label class="control-label"><?php echo e(__('Show View Count on Post page?')); ?></label>
        <?php echo Form::select('ShowViewCount', ['yes' => trans('admin.yes'), 'no' => trans('admin.no')],
        get_buzzy_config('ShowViewCount', 'yes'), ['class' => 'form-control']); ?>

    </div>
    <hr>
    <div class="form-group">
        <label class="control-label"><?php echo e(__('Show Tags on Post page?')); ?></label>
        <?php echo Form::select('ShowTags', ['yes' => trans('admin.yes'), 'no' => trans('admin.no')],
        get_buzzy_config('ShowTags', 'yes'), ['class' => 'form-control']); ?>

    </div>
    <div class="form-group">
        <label class="control-label"><?php echo e(__('Show Author Box on Post page?')); ?></label>
        <?php echo Form::select('ShowAuthorBox', ['yes' => trans('admin.yes'), 'no' => trans('admin.no')],
        get_buzzy_config('ShowAuthorBox', 'yes'), ['class' => 'form-control']); ?>

    </div>
</div>

<div class="tab-pane" id="editor-setting">
    <div class="form-group">
        <label class="control-label"><?php echo e(__('Post Text Editor')); ?></label>
        <?php echo Form::select('site_default_text_editor', [
        'tinymce' => __('TinyMCE Text Editor'),
        'froala' => __('Froala Text Editor'),
        'simditor' => __('Simditor Text Editor')],
        get_buzzy_config('site_default_text_editor', 'tinymce'), ['class' => 'form-control',
        'data-dependecy' => 'text_editor']); ?>

        <span
            class="help-block"><?php echo e(__('Here you can choose the text editor we use on the post create page.')); ?></span>
    </div>
    <div class="form-group" data-target="text_editor" data-value="froala">
        <label class="control-label"><?php echo e(__('Froala Activation Key')); ?></label>
        <input type="text" class="form-control input-lg" name="editor_froala_key"
            value="<?php echo e(get_buzzy_config( 'editor_froala_key' )); ?>">
        <span class="help-block"><a href="https://froala.com/wysiwyg-editor/docs/activation/"
                target="_blank"><?php echo app('translator')->get('v4.see_here_more_info'); ?></a></span>
    </div>
    <div class="form-group">
        <label>
            <?php echo e(__('Filter Categories by Post Format')); ?>

        </label>
        <?php echo Form::select('EditorCategoriesFilter', [
        'yes' => trans('admin.yes'),
        'no' => trans('admin.no')
        ], get_buzzy_config('EditorCategoriesFilter', 'yes'), ['class' => 'form-control']); ?>

            <span class="help-block"><?php echo e(__('Disable this if you want use all categories for any post format.')); ?></span>
    </div>
    <div class="form-group">
        <label>
            <?php echo e(__('Convert non-latin characters on post slug')); ?>

        </label>
        <?php echo Form::select('use_latin_slug', [
        'on' => trans('admin.yes'),
        'off' => trans('admin.no')
        ], get_buzzy_config('use_latin_slug', 'on'), ['class' => 'form-control']); ?>

    </div>
    <div class="form-group">
        <label>
            <?php echo e(__('Users can select post language?')); ?>

        </label>
        <?php echo Form::select('EditorUserCanLanguage', [
        'yes' => trans('admin.yes'),
        'no' => trans('admin.no')
        ], get_buzzy_config('EditorUserCanLanguage', 'no'), ['class' => 'form-control']); ?>

    </div>
    <div class="form-group">
        <label>
            <?php echo e(__('Users can select publish date?')); ?>

        </label>
        <?php echo Form::select('EditorUserCanPublishDate', [
        'yes' => trans('admin.yes'),
        'no' => trans('admin.no')
        ], get_buzzy_config('EditorUserCanPublishDate', 'yes'), ['class' => 'form-control']); ?>

    </div>
    <div class="form-group">
        <label>
            <?php echo e(__('Users can use Get From the URL option?')); ?>

        </label>
        <?php echo Form::select('EditorUserCanGetFromUrl', [
        'yes' => trans('admin.yes'),
        'no' => trans('admin.no')
        ], get_buzzy_config('EditorUserCanGetFromUrl', 'yes'), ['class' => 'form-control']); ?>

    </div>
    <div class="form-group">
        <label><?php echo e(__('Users can use upload video?')); ?></label>
        <?php echo Form::select('EditorUserCanUploadVideol', [
        'yes' => trans('admin.yes'),
        'no' => trans('admin.no')
        ], get_buzzy_config('EditorUserCanUploadVideol', 'yes'), ['class' => 'form-control']); ?>

    </div>
</div>

<div class="tab-pane" id="rss-setting">
    <div class="form-group">
        <label class="control-label"><?php echo e(__('RSS Sitemap post limit')); ?> <a target="_blank" href="<?php echo e(route('sitemap')); ?>"><i class="fa fa-link"></i></a></label>
        <input type="number" class="form-control input-lg" name="RSSSitemapPostLimit" value="<?php echo e(get_buzzy_config('RSSSitemapPostLimit', 500)); ?>">
    </div>
    <div class="form-group">
        <label class="control-label"><?php echo e(__('RSS Feed post limit')); ?> <a target="_blank" href="<?php echo e(route('feed', ['type' => 'feed'])); ?>"><i class="fa fa-link"></i></a></label>
        <input type="number" class="form-control input-lg" name="RSSFeedPostLimit" value="<?php echo e(get_buzzy_config('RSSFeedPostLimit', 500)); ?>">
    </div>
    <div class="form-group">
        <label class="control-label"><?php echo e(__('Google News post limit')); ?> <a target="_blank" href="<?php echo e(route('feed', ['type' => 'googlenews'])); ?>"><i class="fa fa-link"></i></a></label>
        <input type="number" class="form-control input-lg" name="GoogleNewsPostLimit" value="<?php echo e(get_buzzy_config('GoogleNewsPostLimit', 500)); ?>">
    </div>
    <div class="form-group">
        <label class="control-label"><?php echo e(__('Facebook Instant Article post limit')); ?> <a target="_blank" href="<?php echo e(route('fbinstant')); ?>"><i class="fa fa-link"></i></a></label>
        <input type="number" class="form-control input-lg" name="FIAPostLimit" value="<?php echo e(get_buzzy_config('FIAPostLimit', 150)); ?>">
    </div>
</div>

</div>
</div>

            </div>
        </div>
    </div><!-- /.col -->

</div><!-- /.row -->
<?php /**PATH /home/highaltitude/public_html/resources/views/_admin/_particles/config_forms/other.blade.php ENDPATH**/ ?>