<div class="row">
    <div class="col-sm-12  col-md-8 col-lg-6">
        <div class="panel panel-primary">
            <div class="panel-heading"><?php echo e(trans('v3.file_storage_settings')); ?>

                <a href="https://support.akbilisim.com/docs/buzzy/aws-s3-cdn-support" target="_blank" class="btn btn-sm btn-success pull-right -mt-5">
                <i class="fa fa-eye"></i> <?php echo app('translator')->get('v4.see_here_more_info'); ?></a><br>
            </div>
            <div class="panel-body">
                <div class="form-group">
                    <label><?php echo e(trans('v3.activate_s3')); ?></label>
                    <?php echo Form::select('FILESYSTEM_DRIVER', ['local' => trans('admin.no'), 's3' => trans('admin.yes')],
                    env('FILESYSTEM_DRIVER'), ['class' => 'form-control']); ?>

                </div>
                <div class="form-group">
                    <label class="control-label">AWS ACCESS KEY ID</label>
                    <div class="controls">
                        <input type="text" class="form-control input-lg" name="AWS_ACCESS_KEY_ID"
                            value="<?php echo e(env('APP_DEMO') && auth()->user()->isDemoAdmin() ?  "-YOU DON'T HAVE PERMISSION TO SEE THAT-" : env('AWS_ACCESS_KEY_ID')); ?>">
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label">AWS SECRET ACCESS KEY</label>
                    <div class="controls">
                        <input type="text" class="form-control input-lg" name="AWS_SECRET_ACCESS_KEY"
                            value="<?php echo e(env('APP_DEMO') && auth()->user()->isDemoAdmin() ?  "-YOU DON'T HAVE PERMISSION TO SEE THAT-" : env('AWS_SECRET_ACCESS_KEY')); ?>">
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label">AWS REGION</label>
                    <div class="controls">
                        <input type="text" class="form-control input-lg" name="AWS_DEFAULT_REGION"
                            value="<?php echo e(env('AWS_DEFAULT_REGION')); ?>">
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label">AWS BUCKET</label>
                    <div class="controls">
                        <input type="text" class="form-control input-lg" name="AWS_BUCKET"
                            value="<?php echo e(env('AWS_BUCKET')); ?>">
                    </div>
                </div>
                <hr>
                 <div class="form-group">
                    <label class="control-label"><?php echo e(__('Maximum File Upload Size')); ?></label>
                    <div class="controls">
                        <input type="number" class="form-control input-lg" name="user_max_fileupload_size"
                            value="<?php echo e(get_buzzy_config('user_max_fileupload_size')); ?>" placeholder="2000">
                    </div>
                    <span class="help-block"><?php echo e(__('Maximum size for a single file user can upload. Default: 2000=2MB')); ?></span>
                </div>
                <div class="form-group">
                    <label class="control-label"><?php echo e(__('Maximum File Upload Size')); ?> (Video)</label>
                    <div class="controls">
                        <input type="number" class="form-control input-lg" name="user_max_videoupload_size"
                            value="<?php echo e(get_buzzy_config('user_max_videoupload_size')); ?>" placeholder="10000">
                    </div>
                </div>

            </div>
        </div>

    </div><!-- /.col -->

</div><!-- /.row -->
<?php /**PATH /home/highaltitude/public_html/resources/views/_admin/_particles/config_forms/storage.blade.php ENDPATH**/ ?>