<div class="sidebar visiblesidebar-onmobile">
    <div class="sidebar--fixed">
        <div class="question-post-side-bar-form">
            <div class="cd-form" id="previewwrapper">
                <legend><?php echo e(trans('addpost.preview')); ?></legend>
                <div class="thumbwrapper">
                    <div class="previewshow <?php echo e(isset($post->thumb) ? 'show': ''); ?>">
                        <div class="imagepr_wrap">
                            <?php if(isset($post->thumb)): ?> <img src="<?php echo e(makepreview($post->thumb, 's', 'posts')); ?>"> <?php endif; ?>
                        </div>
                        <div class="thumbactions">
                            <a class="button button-red deleteimage" data-action="remove" data-target="thumb"><i class="fa fa-trash"></i></a>
                        </div>
                    </div>
                    <div class="preview-placeholder <?php echo e(isset($post->thumb) ? 'hidden': ''); ?>">
                        <i class="fa fa-plus fa-2x"></i><br>
                        <div class="text-muted"><?php echo e(trans('addpost.pickpreview')); ?></div>
                        <form action="">
                            <input type="file" accept="image/*" class="uploadaimage preview" data-target="preview">
                        </form>
                        <div class="detail-or"> <?php echo e(trans('updates.or')); ?> </div>
                        <div class="image-upload-actions">
                            <a class="button button-white getimageurl" data-action="add"
                                data-target="preview"><?php echo e(trans('updates.getfromurl')); ?> <i
                                    class="fa fa-download"></i></a>
                        </div>
                    </div>
                    <?php echo Form::hidden('thumb', isset($post->thumb) ? makepreview($post->thumb, 'b', 'posts') : null,
                    ['id' => 'upwthumb']); ?>

                </div>
            </div>
            <div class="cd-form">
                <legend><?php echo e(trans('updates.tags')); ?></legend>
                <p class="cd-select icon">
                    <?php echo Form::text('tags', isset($tags) ? $tags : null,
                    ['class' => '', 'id' => 'tags', 'placeholder' => trans('updates.addatag')]); ?>

                </p>
            </div>
            <?php if(auth()->user()->isAdmin() || get_buzzy_config('EditorUserCanPublishDate') !== 'no'): ?>
            <div class="cd-form">
                <legend><?php echo e(trans('v3.publish_date')); ?></legend>
                <p class="cd-select icon">
                    <input type="text" id="published_at" class="cd-input" placeholder="<?php echo e(trans('v3.publish_immediately')); ?>" value="<?php echo e(isset($post->published_at) ? $post->published_at : null); ?>" autocomplete="off">
                </p>
            </div>
            <?php endif; ?>
            <?php if(get_multilanguage_enabled() && (auth()->user()->isAdmin() || get_buzzy_config('EditorUserCanLanguage') !== 'no')): ?>
            <div class="cd-form">
                <legend><?php echo e(trans('v4.post_language')); ?></legend>
                <p class="cd-select icon">
                    <?php echo Form::select('language', get_buzzy_language_list_options(), isset($post->language) ? $post->language : app()->getLocale(), ['id'=> 'language', 'class' => 'form-control']); ?>

                </p>
            </div>
            <?php endif; ?>
            <?php if (! ($post_type == 'quiz' or $post_type == 'poll')): ?>
            <div class="cd-form">
                <legend><?php echo e(trans('updates.pagination')); ?></legend>
                <p class="cd-select icon">
                    <?php echo Form::select('pagination', ['0' => trans('updates.all'), '1' => '1', '2' => '2', '3' => '3', '4'
                    => '4', '5' => '5', '6' => '6', '7' => '7', '8' => '8', '9' => '9', '10' => '10'],
                    isset($post->pagination) ? $post->pagination : null); ?>

                </p>
            </div>
            <?php endif; ?>
            <div class="sidebar-actions">
                <?php echo Form::submit(isset($post->id) ? trans('addpost.savec') : trans('addpost.createp'), ['class' =>
                'button button-orange button-full submit-button PostAction', 'data-post-t' => 'post']); ?>

                <?php echo Form::submit(trans('updates.saveasdraft'), ['class' => 'button button-rosy button-full submit-button
                PostAction', 'data-post-t' => 'draft']); ?>

                <?php if(isset($post->id)): ?>
                <a href="<?php echo e($post->post_link); ?>"
                    class="button button-gray button-full"><?php echo e(trans('addpost.cancel')); ?></a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/highaltitude/public_html/resources/views/editor/_sidebar.blade.php ENDPATH**/ ?>