<div class="box box-widget widget-user widget-plugin">
    <div class="overlay hide">
        <i class="fa fa-refresh fa-spin"></i>
    </div>
    <!-- Add the bg color to the header using any of the bg-* classes -->
    <div class="widget-user-header bg-default">
        <h3 class="widget-user-username"><?php echo e($name); ?></h3>
        <h5 class="widget-user-desc""><?php echo $desc; ?> </h5>
        <div class="info">
            <?php echo $weblink == null ? '' : '<a href="'.$weblink.'" target="_blank"><i class="fa fa-globe"></i> Web site</a>'; ?>

            <?php echo $docslink == null ? '' : '<a href="'.$docslink.'" target="_blank"><i class="fa fa-book"></i> '.trans("admin.Docs").'</a>'; ?>

            <?php if($price!='soon' && !empty($current_version)): ?><span class="text-gray">v.<?php echo e($current_version); ?></span><?php endif; ?>
        </div>
    </div>
    <div class="widget-user-image">
        <img class="img-circle" src="<?php echo e($icon); ?>" alt="<?php echo e($name); ?>">
    </div>

    <div class="box-footer">
        <div class="row">
            <div class="col-sm-9 item-actions" data-item-code="<?php echo e($code); ?>" data-item-id="<?php echo e($item_id); ?>"
                data-item-type="plugin">
                <?php if (! ($price=='soon')): ?>
                <?php if($activation_requied): ?>
                <a href="javascript:;" data-item-id="<?php echo e($item_id); ?>" data-item-name="<?php echo e($name); ?>" data-item-buy="<?php echo e($buylink); ?>" data-item-img="<?php echo e($icon); ?>" class="btn btn-warning btn-sm pull-left register-item">
                    <i class="fa fa-unlock mr-5"></i> <?php echo e(trans('admin.ActivateCode')); ?>

                </a>
                <?php if($buylink != null): ?>
                <a href="<?php echo e($buylink); ?>" class="btn btn-success pull-left btn-sm" target="_blank">
                    <i class="fa fa-cart-plus mr-5"></i> <?php echo e(trans("admin.BuyNow")); ?>

                </a>
                <?php endif; ?>
                <?php elseif(!$instaled): ?>
                <button type="button" class="btn btn-info btn-sm pull-left download-item" data-item-code="<?php echo e($code); ?>" data-item-id="<?php echo e($item_id); ?>" data-version="<?php echo e($version); ?>">
                    <i class="fa fa-check mr-5"></i> <?php echo e(trans('admin.download')); ?>

                </button>
                <?php elseif($update_required): ?>
                <button type="button" class="btn btn-success btn-sm pull-left download-item" data-item-code="<?php echo e($code); ?>" data-item-id="<?php echo e($item_id); ?>" data-version="<?php echo e($version); ?>">
                    <i class="fa fa-download mr-5"></i>  <?php echo e(trans('admin.download')); ?>

                    v.<?php echo e($version); ?>

                </button>
                <?php elseif($active): ?>
                <button type="button" class="btn btn-default btn-sm pull-left activate-item acthover">
                    <span class="current show"><i class="fa fa-check mr-5"></i> <?php echo e(trans('admin.Activated')); ?></span>
                    <span class="hover hide"><i class="fa fa-remove mr-5"></i> <?php echo e(trans('admin.Deactivate')); ?></span>
                </button>
                <?php if($settingon): ?>
                <button type="button" class="btn btn-warning btn-sm pull-left" data-toggle="modal" data-target="#modal<?php echo e($code); ?>">
                    <i class="fa fa-cog"></i>
                </button>
                <?php endif; ?>
                <?php else: ?>
                <button type="button" class="btn btn-info btn-sm pull-left activate-item">
                    <i class="fa fa-download mr-5"></i> <?php echo e(trans('admin.Install')); ?>

                </button>
                <?php endif; ?>
                <?php endif; ?>
            </div>
            <!-- /.col -->
            <!-- /.col -->
            <div class="col-sm-3" >
                <?php if($price=='soon'): ?>
                <span class="badge bg-white pull-right mr-10"><?php echo trans("admin.Notavailabeyet"); ?></span>
                <?php elseif($price=='FREE'): ?>
                <span class="badge bg-white pull-right mr-10"><?php echo trans("admin.FREE"); ?></span>
                <?php else: ?>
                <span class="badge bg-green pull-right mr-10"><?php echo e($price); ?></span>
                <?php endif; ?>
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </div>

    <?php if($settingon): ?>
    <div class="modal modal-info" id="modal<?php echo e($code); ?>">
        <div class="modal-dialog <?php echo e($code=="homepagebuilder" ? 'full' : ''); ?>">
            <div class="modal-content">
                <?php echo Form::open(array('action' => 'Admin\ConfigController@setconfig', 'method' => 'POST','style' =>
                'height:100%;', 'enctype' => 'multipart/form-data')); ?>

                <?php echo $__env->make('_admin._particles.plugin_settings.'. $code, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="clearfix"></div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline pull-left" data-dismiss="modal"><?php echo trans("admin.close"); ?></button>
                    <input type="submit" value="<?php echo e(trans("admin.SaveSettings")); ?>" class="btn btn-info btn-outline">
                </div>
                <?php echo Form::close(); ?>

            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <?php endif; ?>
</div>
<?php /**PATH /home/highaltitude/public_html/resources/views/_admin/_particles/plugin_box.blade.php ENDPATH**/ ?>