<section class="sidebar">
    <!-- Sidebar user panel -->
    <div class="user-panel">
        <div class="pull-left image">
            <img src="<?php echo e(makepreview(Auth::user()->icon, 's', 'members/avatar')); ?>" class="img-circle" alt="User Image">
        </div>
        <div class="pull-left info">
            <p><?php echo e(Auth::user()->username); ?></p>
            <a href="#"><i class="fa fa-circle text-success"></i> <?php echo e(trans('admin.Online')); ?></a>
        </div>
    </div>
    <!-- sidebar menu: : style can be found in sidebar.less -->
    <ul class="sidebar-menu">
        <li class="header"><?php echo e(trans('admin.MAINNAVIGATION')); ?></li>
        <li class="<?php echo e(request()->route()->named('admin.dashboard') ? 'active' : ''); ?>">
            <a href="<?php echo e(action('Admin\DashboardController@index')); ?>">
                <i class="fa fa-dashboard"></i> <span><?php echo e(trans('admin.dashboard')); ?></span>
            </a>
        </li>
        <?php if(get_buzzy_config('p_buzzycontact') == 'on'): ?>
        <li class="<?php echo e(request()->route()->named('admin.mailbox') ? 'active' : ''); ?>">
            <a href="<?php echo e(route('admin.mailbox')); ?>">
                <i class="fa fa-envelope"></i> <span><?php echo e(trans('admin.Inbox')); ?></span>
                <?php if($unapproveinbox >0): ?>
                <span class="pull-right badge bg-green"><?php echo e($unapproveinbox); ?></span>
                <?php endif; ?>
            </a>
        </li>
        <?php endif; ?>
        <li <?php if(request()->route()->named('admin.themes')): ?> class="active" <?php endif; ?>>
            <a href="<?php echo e(route('admin.themes')); ?>">
                <i class="fa fa-eye"></i> <span><?php echo e(trans('themes.themes')); ?></span>
            </a>
        </li>
        <li <?php if(request()->route()->named('admin.plugins')): ?> class="active" <?php endif; ?>>
            <a href="<?php echo e(route('admin.plugins')); ?>">
                <i class="fa fa-puzzle-piece"></i> <span><?php echo e(trans('admin.Plugins')); ?></span>
            </a>
        </li>
        <li class="treeview  <?php if(request()->route()->named('admin.configs')): ?> active <?php endif; ?>">
            <a href="<?php echo e(route('admin.configs')); ?>">
                <i class="fa fa-cog"></i> <span><?php echo e(trans('admin.Settings')); ?></span>
                <i class="fa fa-angle-left pull-right"></i>
            </a>
            <ul class="treeview-menu">
                <?php $__currentLoopData = [
                '' => trans('admin.GeneralSettings'),
                'mail' => trans('admin.MailSettings'),
                'login' => trans('v4.login_settings'),
                'comment' => __('Comments Settings'),
                'social' => trans('admin.SocialMediaSettings'),
                'storage' => trans('v3.file_storage_settings'),
                'recaptcha' => trans('v4.recaptcha_settings'),
                'permissions' => __('Permission Settings'),
                'others' => trans('admin.OtherSettings'),
                'advanced' => trans('admin.AdvancedConfiguration'),
                ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="<?php echo e(request()->query('q')==$key ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('admin.configs', ['q' => $key])); ?>">
                        <i class="fa fa-caret-right"></i>
                        <?php echo e($item); ?></a>
                </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </li>
        <li <?php if(request()->route()->named('admin.menus') || request()->route()->named('admin.menu.show')): ?> class="active" <?php endif; ?>>
            <a href="<?php echo e(route('admin.menus')); ?>">
                <i class="fa fa-bars"></i> <span><?php echo e(trans('v4.menus')); ?></span>
            </a>
        </li>
        <li <?php if(request()->route()->named('admin.categories')): ?> class="active" <?php endif; ?>>
            <a href="<?php echo e(route('admin.categories')); ?>">
                <i class="fa fa-folder"></i>
                <span><?php echo e(trans('admin.Categories')); ?></span>
            </a>
        </li>
        <?php if(get_buzzy_config('p_buzzycomment')=='on'): ?>
        <li class="treeview <?php echo e(request()->route()->named('admin.comments') ? 'active' : ''); ?>">
            <a href="users">
                <i class="fa fa-comment"></i>
                <span><?php echo e(__('Comments')); ?></span>
                <i class="fa fa-angle-left pull-right"></i>
            </a>
            <ul class="treeview-menu">
                <li class="<?php echo e(request()->query('only')=='' ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('admin.comments')); ?>">
                        <i class="fa fa-caret-right"></i>
                        <?php echo e(__('Comments')); ?>

                    </a>
                </li>
                <li class="<?php echo e(request()->query('only')=='unapprove' ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('admin.comments',  ['only' => 'unapprove'])); ?>">
                        <i class="fa fa-caret-right"></i>
                        <?php echo e(trans('admin.Unapproved', ['type' => __('Comments') ])); ?>

                        <small class="label pull-right bg-aqua"><?php echo e($total_comment_approve); ?></small>
                    </a>
                </li>
                <li class="<?php echo e(request()->query('only')=='deleted' ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('admin.comments',  ['only' => 'deleted'])); ?>">
                        <i class="fa fa-caret-right"></i>
                        <?php echo e(trans('admin.Trash', ['type' => __('Comments') ])); ?>

                    </a>
                </li>
                <li class="<?php echo e(request()->query('only')=='reported' ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('admin.comments',  ['only' => 'reported'])); ?>">
                        <i class="fa fa-caret-right"></i>
                        <?php echo e(__('Reported :type', ['type' => __('Comments') ])); ?>

                    </a>
                </li>
            </ul>
        </li>
        <?php endif; ?>
        <li class="<?php echo e(request()->route()->named('admin.posts') && empty(request()->query('type')) && request()->query('only')=='' ? 'active': ''); ?>">
            <a href="<?php echo e(route('admin.posts')); ?>">
                <i class="fa fa-book"></i>
                <span><?php echo e(trans('admin.LatestPosts')); ?></span>
            </a>
        </li>
        <li class="<?php echo e(request()->route()->named('admin.posts') && empty(request()->query('type')) && request()->query('only')=='featured' ? 'active': ''); ?>">
            <a href="<?php echo e(route('admin.posts',  ['only' => 'featured'])); ?>">
                <i class="fa fa-star"></i>
                <span><?php echo e(trans('admin.FeaturesPosts')); ?></span>
            </a>
        </li>
        <li class="treeview <?php echo e(request()->route()->named('admin.posts') && empty(request()->query('type')) && request()->query('only')=='deleted' ? 'active': ''); ?>">
            <a href="<?php echo e(route('admin.posts',  ['only' => 'deleted'])); ?>">
                <i class="fa fa-trash"></i>
                <span><?php echo e(trans('admin.Trash', ['type' => trans('admin.Posts') ])); ?></span>
            </a>
        </li>
        <li class="treeview <?php echo e(request()->route()->named('admin.posts') && empty(request()->query('type')) && request()->query('only')=='unapprove' ? 'active': ''); ?>">
            <a href="<?php echo e(route('admin.posts',  ['only' => 'unapprove'])); ?>">
                <i class="fa fa-check-circle"></i>
                <span><?php echo e(trans('admin.UnapprovedPosts')); ?></span>
                <small class="label pull-right bg-aqua"><?php echo e($total_approve); ?></small>
            </a>
        </li>
        <?php $__currentLoopData = \App\Category::byMain()->byLanguage()->byActive()->orderBy('order')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <li class="treeview  <?php if(request()->query('category_id')==$cat->id): ?> active <?php endif; ?>">
            <a href="<?php echo e(route('admin.posts', ['type' => 'category', 'category_id' => $cat->id])); ?>">
                <?php echo '<i class="fa fa-' . config('buzzy.post_types.' . $cat->type. '.icon') . '"></i>'; ?>

                <span><?php echo e($cat->name); ?></span>
                <i class="fa fa-angle-left pull-right"></i>
            </a>
            <ul class="treeview-menu">
                <li class="<?php if(request()->query('category_id')==$cat->id && request()->query('only')==''): ?> active <?php endif; ?>">
                    <a href="<?php echo e(route('admin.posts',  ['type' => 'category', 'category_id' => $cat->id])); ?>"><i class="fa fa-eye"></i>
                        <?php echo e(trans('admin.view', ['type' => $cat->name ])); ?>

                    </a>
                </li>
                <li class="<?php if(request()->query('only')=='unapprove'): ?> active <?php endif; ?>">
                    <a href="<?php echo e(route('admin.posts',  ['type' => 'category', 'category_id' => $cat->id, 'only' => 'unapprove'])); ?>"><i class="fa fa-check-circle"></i><?php echo e(trans('admin.Unapproved', ['type' => $cat->name ])); ?>

                        <small class="label pull-right bg-aqua"><?php echo e($napprovenews); ?></small>
                    </a>
                </li>
                <li class="<?php if(request()->query('only')=='deleted'): ?> active <?php endif; ?>">
                    <a href="<?php echo e(route('admin.posts',  ['type' => 'category', 'category_id' => $cat->id, 'only' => 'deleted'])); ?>"><i class="fa fa-trash-o"></i>
                        <?php echo e(trans('admin.Trash', ['type' => $cat->name ])); ?>

                    </a>
                </li>
            </ul>
        </li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <li class="treeview <?php echo e(request()->route()->named('admin.users') ? 'active' : ''); ?>">
            <a href="users">
                <i class="fa fa-users"></i>
                <span><?php echo e(trans('admin.Users')); ?></span>
                <i class="fa fa-angle-left pull-right"></i>
            </a>
            <ul class="treeview-menu">
                <li><a href="<?php echo e(route('admin.users')); ?>"><i class="fa fa-caret-right"></i> <?php echo e(trans('admin.Users')); ?></a></li>
                <li><a href="<?php echo e(route('admin.users', ['only' => 'banned'])); ?>"><i class="fa fa-caret-right"></i>
                        <?php echo e(trans('admin.BannedUsers')); ?> </a></li>
                <li><a href="<?php echo e(route('admin.users', ['only' => 'admins'])); ?>"><i class="fa fa-caret-right"></i>
                        <?php echo e(trans('admin.Admins')); ?></a></li>
                <li><a href="<?php echo e(route('admin.users', ['only' => 'staff'])); ?>"><i class="fa fa-caret-right"></i> <?php echo e(trans('admin.Staff')); ?></a>
                </li>
            </ul>
        </li>

        <li class="<?php echo e(request()->route()->named('admin.pages') ? 'active' : ''); ?>">
            <a href="<?php echo e(route('admin.pages')); ?>">
                <i class="fa fa-files-o"></i>
                <span><?php echo e(trans('admin.Pages')); ?></span>
            </a>
        </li>
        <li class="treeview <?php echo e(request()->route()->named('admin.reactions') ? 'active' : ''); ?>">
            <a href="<?php echo e(route('admin.reactions')); ?>">
                <i class="fa fa-thumbs-o-up"></i>
                <span>Reactions</span>
            </a>
        </li>
        <li class="treeview <?php echo e(request()->route()->named('admin.widgets') ? 'active' : ''); ?>">
            <a href="<?php echo e(route('admin.widgets')); ?>">
                <i class="fa fa-plus-square"></i>
                <span><?php echo e(trans('admin.Widgets')); ?></span>
            </a>
        </li>
        <li class="treeview <?php echo e(request()->route()->named('admin.translations') ? 'active' : ''); ?>">
            <a href="<?php echo e(route('admin.translations')); ?>">
                <i class="fa fa-language"></i>
                <span><?php echo e(__('Translations')); ?></span>
            </a>
        </li>
        <li class="treeview <?php echo e(request()->route()->named('admin.feeds') ? 'active' : ''); ?>">
            <a href="<?php echo e(route('admin.feeds')); ?>">
                <i class="fa fa-rss"></i>
                <span><?php echo e(trans('v4half.feeds_fetcher')); ?></span>
                <span class="pull-right badge bg-red hide"><?php echo e(trans('admin.NEW')); ?></span>
            </a>
        </li>
        <li class="treeview <?php echo e(request()->route()->named('admin.tools') ? 'active' : ''); ?>">
            <a href="<?php echo e(route('admin.tools')); ?>">
                <i class="fa fa-database"></i>
                <span><?php echo e(trans('v3.tools')); ?></span>
            </a>
        </li>
        <li class="treeview">
            <a href="<?php echo e(route('sitemap')); ?>" target="_blank">
                <i class="fa fa-rss"></i>
                <span><?php echo e(trans('admin.Sitemap')); ?></span>
            </a>
        </li>
        <li>
            <a target=_blank href="https://support.akbilisim.com/docs/buzzy/installation">
                <i class="fa fa-book"></i>
                <span> <?php echo e(trans('admin.documentation')); ?></span>
            </a>
        </li>
        <li class="header"><?php echo e(trans('admin.UnapprovedPosts')); ?></li>
        <?php if(get_buzzy_config('p_buzzynews') == 'on'): ?>
            <li><a href="javascript:"><i class="fa fa-circle-o text-aqua"></i>
                <span><?php echo e(trans('index.news')); ?></span><small class="label pull-right bg-aqua"><?php echo e($napprovenews); ?></small></a>
                </li>
            <?php endif; ?>
        <?php if(get_buzzy_config('p_buzzylists') == 'on'): ?>
            <li><a href="javascript:"><i class="fa fa-circle-o text-green"></i>
                <span><?php echo e(trans('index.list')); ?></span><small class="label pull-right bg-green"><?php echo e($napprovelists); ?></small></a></li>
            <?php endif; ?>
        <?php if(get_buzzy_config('p_buzzyquizzes') == 'on'): ?>
            <li><a href="javascript:"><i
                    class="fa fa-circle-o text-purple"></i> <span><?php echo e(trans('index.quiz')); ?></span><small
                    class="label pull-right bg-purple"><?php echo e($unapprovequizzes); ?></small></a></li>
        <?php endif; ?>
        <?php if(get_buzzy_config('p_buzzypolls') == 'on'): ?>
            <li><a href="javascript:"><i
                    class="fa fa-circle-o text-yellow"></i> <span><?php echo e(trans('index.poll')); ?></span><small
                    class="label pull-right bg-yellow"><?php echo e($napprovepolls); ?></small></a></li>
        <?php endif; ?>
        <?php if(get_buzzy_config('p_buzzyvideos') == 'on'): ?>
            <li><a href="javascript:"><i class="fa fa-circle-o text-red"></i>
                <span><?php echo e(trans('index.video')); ?></span><small class="label pull-right bg-red"><?php echo e($napprovevideos); ?></small></a></li>
        <?php endif; ?>
    </ul>
</section>
<?php /**PATH /home/highaltitude/public_html/resources/views/_admin/_particles/sidebar.blade.php ENDPATH**/ ?>