<div class="box">
    <?php echo Form::open(array('action' => isset($menu_item->id) ? 'Admin\MenuItemController@update' :
    'Admin\MenuItemController@store', 'method' =>isset($menu_item->id) ? 'PUT' : 'POST')); ?>

    <?php echo e(csrf_field()); ?>

    <input type="hidden" name="menu_id" value="<?php echo e($menu->id); ?>">
    <input type="hidden" name="id" value="<?php echo e(isset($menu_item->id) ? $menu_item->id : null); ?>">
    <div class="box-body">
        <div class="form-group">
            <label for="add_menu_item_title" class="cs-label"><?php echo e(trans('v4.menu_title')); ?> <span class="text-red">*</span></label>
            <?php echo Form::text('title', isset($menu_item->title) ? $menu_item->title : old('title'), ['id' =>
            'add_menu_item_title', 'class' => 'form-control input-field mb-2']); ?>

        </div>
        <div class="form-group">
            <label for="add_menu_item_url" class="cs-label"><?php echo e(trans('v4.menu_url')); ?></label>
            <?php echo Form::text('url', isset($menu_item->url) ? $menu_item->url : old('url'), ['id' => 'add_menu_item_url',
            'class' => 'form-control input-field mb-2']); ?>

        </div>
        <div class="form-group">
            <label for="add_menu_item_target" class="cs-label"><?php echo e(trans('v4.open_in')); ?></label>
            <?php echo Form::select('target', ['_self'=> trans('v4.same_tab'), '_blank'=>trans('v4.new_tab')],
            isset($menu_item->target) ? $menu_item->target : old('target') , ['class' => 'form-control input-field
            mb-2']); ?>

        </div>
        <div class="form-group">
            <label for="add_menu_item_custom_class" class="cs-label"><?php echo e(trans('v4.menu_icon')); ?></label>
            <?php echo Form::text('icon', isset($menu_item->icon) ? $menu_item->icon : old('icon'), ['id' =>
            'add_menu_item_icon', 'class' => 'form-control input-field mb-2']); ?>

            Find your font code <a href="https://material.io/icons/" target="_blank">here.</a> Example
            code:<code>library_books</code><br>
        </div>
        <div class="form-group">
            <label for="add_menu_item_custom_class" class="cs-label"><?php echo e(trans('v4.custom_class')); ?></label>
            <?php echo Form::text('custom_class', isset($menu_item->custom_class) ? $menu_item->custom_class :
            old('custom_class'), ['id' => 'add_menu_item_custom_class', 'class' => 'form-control input-field mb-2']); ?>

        </div>
        <?php if(get_multilanguage_enabled()): ?>
        <div class="form-group">
            <label for="add_menu_item_custom_class" class="cs-label"><?php echo e(trans('v4half.menu_language')); ?></label>
            <?php echo Form::select('language', get_buzzy_language_list_options(), ! empty($menu_item->language) ?
            $menu_item->language : get_buzzy_locale() , [
            "id"=>"changeLanguage",
            'id' => 'add_menu_item_language', 'class' => 'form-control input-field mb-2']); ?>

        </div>
        <?php endif; ?>
        <div>

            <button type="submit"
                class="btn btn-<?php echo e(isset($menu_item->id) ? 'success': 'primary'); ?> edit-info"><?php echo e(isset($menu_item->id) ? trans('v4.update_menu_item'): trans('v4.add_menu_item')); ?></button>
            <?php if(isset($menu_item->id)): ?>
            <a href="<?php echo e(route('admin.menu.show', ['menu' => $menu->id])); ?>" class="btn btn-default pull-right"><?php echo e(trans('admin.Cancel')); ?></a>

            <?php endif; ?>
        </div>
    </div>
    <?php echo Form::close(); ?>

</div>
<div class="box">
    <div class="box-body">
        <?php echo Form::open(array('action' => 'Admin\MenuItemController@storeFromCategory', 'method' => 'POST')); ?>

        <div class="form-group">
            <?php echo Form::label('parent_cat',trans('v4half.add_menu_for_category')); ?>

            <?php echo e(csrf_field()); ?>

            <input type="hidden" name="menu_id" value="<?php echo e($menu->id); ?>">
            <input type="hidden" name="language" value="<?php echo e(get_buzzy_locale()); ?>">
            <select class="form-control" name="category_id">
                <?php $__currentLoopData = \App\Category::byMain()->byLanguage(get_buzzy_locale())->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alt_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <optgroup>
                    <option value="<?php echo e($alt_category->id); ?>">
                        <?php echo e($alt_category->name); ?>

                    </option>
                    <?php $__currentLoopData = $alt_category->children()->orderBy('name')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $altalt_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($altalt_category->id); ?>">
                        <?php echo e($alt_category->name); ?> / <?php echo e($altalt_category->name); ?>

                    </option>
                    <?php $__currentLoopData = $altalt_category->children()->orderBy('name')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $altaltalt_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($altaltalt_category->id); ?>">
                        <?php echo e($alt_category->name); ?> / <?php echo e($altalt_category->name); ?> / <?php echo e($altaltalt_category->name); ?>

                    </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </optgroup>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <button type="submit" class="btn btn-primary edit-info"><?php echo e(trans('v4.add_menu_item')); ?></button>

        <?php echo Form::close(); ?>

    </div>
</div>
<?php /**PATH /home/highaltitude/public_html/resources/views/_admin/pages/menus/particles/menu-item-form.blade.php ENDPATH**/ ?>