<?php $__env->startSection('header'); ?>
<!-- bootstrap wysihtml5 - text editor -->
<link rel="stylesheet"
    href="<?php echo e(asset('assets/plugins/adminlte/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection("content"); ?>
<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>
        <?php echo e(trans('admin.Pages')); ?>

    </h1>
    <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> <?php echo e(trans('admin.dashboard')); ?></a></li>
        <li class="active"><?php echo e(trans('admin.Pages')); ?></li>
    </ol>
</section>
<section class="content">
    <div class="row">
          <div class="col-md-6">
            <?php echo Form::open(array('action' => 'Admin\PagesController@store', 'method' => 'POST', 'enctype' => 'multipart/form-data')); ?>

            <input type="hidden" name="id" value="<?php echo e(isset($page->id) ? $page->id : null); ?>">
            <div class="panel panel-info">
                <div class="panel-heading"><?php echo e(trans('admin.CreatePage')); ?></div>
                <div class="panel-body">

                    <div class="form-group">
                        <label><?php echo e(trans('admin.Title')); ?></label>
                        <input type="text" name="title" class="form-control input-lg"
                            placeholder="<?php echo e(trans('admin.Title')); ?>"
                            value="<?php echo e(isset($page->title) ? $page->title : null); ?>">
                    </div>

                    <div class="form-group">
                        <label><?php echo e(trans('admin.TitleSlug')); ?></label>
                        <input type="text" name="slug" class="form-control input-lg"
                            placeholder="<?php echo e(trans('admin.TitleSlug')); ?>"
                            value="<?php echo e(isset($page->slug) ? $page->slug : null); ?>">
                    </div>

                    <div class="form-group">
                        <label><?php echo e(trans('admin.Descriptiontag')); ?></label>
                        <input type="text" name="description" class="form-control input-lg" placeholder=""
                            value="<?php echo e(isset($page->description) ? $page->description : null); ?>">
                    </div>
                    <hr>
                    <div class="form-group">
                        <label><?php echo e(trans('admin.text')); ?></label>
                        <textarea name="text" class="textarea" id="textarea"
                            placeholder="<?php echo e(trans('admin.Placesometexthere')); ?>"><?php echo e(isset($page->text) ? $page->text : null); ?></textarea>
                    </div>

                </div>
            </div>

            <input type="submit"
                value="<?php echo e(isset($page->title) ? trans('admin.SaveChanges') : trans('admin.CreatePage')); ?>"
                class="btn btn-block btn-info btn-lg">
            <?php echo Form::close(); ?>


        </div><!-- /.col -->
        <div class="col-md-6">
            <div class="box">
                <div class="box-header with-border">
                    <h3 class="box-title"><?php echo e(trans('admin.AllPages')); ?> (<?php echo e(count($pages)); ?>)</h3>
                </div><!-- /.box-header -->
                <div class="box-body">
                    <table class="table table-bordered">
                        <tbody>
                            <tr>
                                <th>#</th>
                                <th><?php echo e(trans('admin.PageTitle')); ?></th>
                                <th><?php echo e(trans('admin.actions')); ?></th>
                            </tr>
                            <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($key+1); ?>.</td>
                                <td><?php echo e($page->title); ?> <a href="<?php echo e(route('page.show', ['page' => $page->slug])); ?>" target="_blank"><i class="fa fa-external-link"></i></a></td>
                                <td>
                                    <a href="<?php echo e(route('admin.pages', ['edit' => $page->id])); ?>" class="btn btn-sm btn-success" role="button"
                                        data-toggle="tooltip" data-original-title="<?php echo e(trans('admin.edit')); ?>"><i
                                            class="fa fa-edit"></i></a>
                                    <a class="btn btn-sm btn-danger permanently"
                                        href="<?php echo e(route('admin.pages.delete', ['page' => $page->id])); ?>" role="button"
                                        data-toggle="tooltip" data-original-title="<?php echo e(trans('admin.delete')); ?>"><i
                                            class="fa fa-times"></i></a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div><!-- /.box-body -->

            </div>

        </div><!-- /.col -->
    </div><!-- /.row -->

</section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("footer"); ?>
<!-- Bootstrap WYSIHTML5 -->
<script src="<?php echo e(asset('assets/plugins/tinymce/tinymce.min.js')); ?>"></script>
<script>
(function ($) {
        "use strict";

          tinymce.init({
                selector: 'textarea',
                language: "<?php echo e(config('app.locale')); ?>",
                directionality: "<?php echo e(get_language_is_rtl(get_buzzy_locale()) ? 'rtl' : 'ltr'); ?>",
                images_upload_url:
                    "<?php echo route('upload_image_request', ['type' => 'page', 'path_key' => 'location', '_token' => csrf_token() ]); ?>",
                menubar: false,
                statusbar: false,
                min_height: 300,
                default_link_target: '_blank',
                plugins:
                    'save print preview importcss searchreplace autoresize autolink directionality visualblocks visualchars fullscreen image link media template codesample table charmap hr pagebreak nonbreaking toc insertdatetime advlist lists wordcount imagetools textpattern noneditable help charmap quickbars emoticons codeeditor',
                toolbar:
                    'formatselect | bold italic underline strikethrough | alignleft aligncenter alignright alignjustify | numlist bullist checklist | image media link |  undo redo | fontselect fontsizeselect | outdent indent | forecolor backcolor casechange permanentpen formatpainter removeformat | pagebreak codesample | charmap emoticons | paste copy fullscreen preview print codeeditor',
                setup: function (editor) {
                    editor.on('change blur', function (e) {
                        editor.save();
                        tinymce.triggerSave();
                    });
                }
            });

  })(jQuery);
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("_admin.adminapp", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/highaltitude/public_html/resources/views/_admin/pages/pages.blade.php ENDPATH**/ ?>