<?php ($comments = \App\Comment::approved(false)->take(5)->latest()->get()); ?>
<div class="box box-info">
    <div class="box-header with-border">
        <h3 class="box-title"><?php echo e(trans('admin.Unapproved', ['type' => __('Comments') ])); ?></h3>
        <div class="box-tools pull-right">
            <button class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
            <button class="btn btn-box-tool" data-widget="remove"><i class="fa fa-times"></i></button>
        </div>
    </div><!-- /.box-header -->
    <div class="box-body">
        <?php if($comments): ?>
        <div class="table-responsive">
            <table class="table no-margin">
                <thead>
                    <tr>
                        <th width="70%"><?php echo e(__('Comment')); ?></th>
                        <th width="15%"><?php echo e(trans('admin.actions')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <div class="product-info">
                            <p><?php echo e(strip_tags(\Str::limit($item->comment, 150))); ?></p>
                            <span class="product-description text-gray">
                            <i class="fa fa-user mr-5"></i>
                            <?php if($item->userdata->type =='guest'): ?>
                             <?php echo e($item->userdata->username); ?> (<?php echo e(__('Guest')); ?>)
                            <?php else: ?>
                            <a href="<?php echo e($item->userdata->link); ?>" target="_blank">
                            <?php echo e($item->userdata->username); ?>

                            </a>
                            <?php endif; ?>
                            <i class="fa fa-clock-o ml-10 mr-5" ></i> <?php echo e($item->created_at->diffForHumans()); ?>

                            <?php if($item->post): ?>
                            <a href="<?php echo e(generate_comment_url($item)); ?>" target="_blank" class="ml-10">
                            <i class="fa fa-file-text mr-5"></i>
                            <?php echo e(Str::limit($item->post->title, 25)); ?>

                            </a>
                            <?php endif; ?>
                            </span>
                            </div>
                        </td>
                        <td>
                            <div class="input-group-btn">
                                <button type="button" class="btn btn-default dropdown-toggle"
                                    data-toggle="dropdown" aria-expanded="false">
                                    <?php echo e(trans('admin.actions')); ?>

                                        <span class="fa fa-caret-down"></span>
                                </button>
                                <ul class="dropdown-menu pull-right">
                                    <li>
                                        <a href="<?php echo e(action('Admin\CommentController@bulkAction',  ['ids' => $item->id, 'action' => 'approve'])); ?>">
                                            <?php echo e(trans('admin.Approve')); ?>

                                        </a>
                                    </li>
                                    <li class="divider"></li>
                                    <li>
                                        <a target=_blank href="<?php echo e(generate_comment_url($item)); ?>">
                                            <?php echo e(__('Edit Comment')); ?>

                                        </a>
                                    </li>
                                    <li class="divider"></li>
                                    <li>
                                        <a class="sendtrash" href="<?php echo e(action('Admin\CommentController@bulkAction', ['ids' => $item->id, 'action' => 'delete'])); ?>">
                                            <?php echo e(trans('admin.sendtrash')); ?>

                                        </a>
                                    </li>
                                    <li>
                                        <a class="permanently" href="<?php echo e(action('Admin\CommentController@bulkAction', ['ids' => $item->id, 'action' => 'forceDelete'])); ?>">
                                            <?php echo e(trans('admin.deletepermanently')); ?>

                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div><!-- /.table-responsive -->
        <?php else: ?>
        <?php echo e(trans('admin.nothingtoseehere')); ?>

        <?php endif; ?>
    </div><!-- /.box-body -->
    <div class="box-footer text-center">
        <a href="<?php echo e(route('admin.comments',  ['only' => 'unapprove'])); ?>" class="uppercase"><?php echo e(trans('admin.viewall')); ?></a>
    </div><!-- /.box-footer -->
</div>
<?php /**PATH /home/highaltitude/public_html/resources/views/_admin/_particles/dashboard/unapproved-comments.blade.php ENDPATH**/ ?>