<div class="clearfix" itemprop="author" itemscope itemtype="https://schema.org/Person">
    <?php if(isset($post->user->username_slug)): ?>
    <div itemprop="image" itemscope itemtype="https://schema.org/ImageObject">
        <meta itemprop="url" content="<?php echo e(makepreview($post->user->icon , 'b', 'members/avatar')); ?>">
        <meta itemprop="width" content="200">
        <meta itemprop="height" content="200">
    </div>
    <meta itemprop="name" content="<?php echo e($post->user->username); ?>">
    <?php if(isset($post->user->facebook)): ?>
    <meta itemprop="sameAs" content="<?php echo e($post->user->facebook); ?>"><?php endif; ?>
    <?php if(isset($post->user->twitter)): ?>
    <meta itemprop="sameAs" content="<?php echo e($post->user->twitter); ?>"><?php endif; ?>
    <?php if(get_buzzy_config('ShowAuthor') !== 'no'): ?>
    <div class="user-info <?php echo e($post->user->genre); ?> answerer">
        <div class="avatar left">
            <img src="<?php echo e(makepreview($post->user->icon , 's', 'members/avatar')); ?>" width="45" height="45"
                alt="<?php echo e($post->user->username); ?>">
        </div>
        <div class="info">
            <a itemprop="name" class="content-info__author"
                href="<?php echo e($post->user->profile_link); ?>"
                target="_self"><?php echo e($post->user->username); ?></a>
            <?php if(get_buzzy_config('ShowAuthorBadge') !== 'no'): ?>
            <?php if($post->user->usertype == 'Admin'): ?>
            <div class="label label-admin ml5"><?php echo e(trans('updates.usertypeadmin')); ?></div>
            <?php elseif($post->user->usertype == 'Staff'): ?>
            <div class="label label-staff ml5"><?php echo e(trans('updates.usertypestaff')); ?></div>
            <?php elseif($post->user->usertype == 'banned'): ?>
            <div class="label label-banned ml5"><?php echo e(trans('updates.usertypebanned')); ?></div>
            <?php endif; ?>
            <?php endif; ?>
            <div class="detail">
                <?php if(get_buzzy_config('ShowPublishDate') !== 'no'): ?>
                <?php echo trans('index.postedon', ['time' => '<time  class="content-info__date">'.$post->published_at->diffForHumans() .'</time>' ]); ?>

                <?php endif; ?>
                <?php if(get_buzzy_config('ShowUpdateDate') !== 'no' && $post->updated_at->getTimestamp() > $post->published_at->getTimestamp()): ?>
                <em class="content-info__line">—</em> <?php echo trans('index.updatedon', ['time' => '<time class="content-info__date">'.$post->updated_at->diffForHumans() .'</time>' ]); ?>

                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php if(isset($show_views) && get_buzzy_config('ShowViewCount') !== 'no'): ?>
    <div class="content-share__view">
        <b><?php echo e($post->all_time_stats ? number_format($post->all_time_stats) : "0"); ?></b><br>
        <?php echo e(trans('updates.views')); ?>

    </div>
    <?php endif; ?>
    <?php endif; ?>
    <?php endif; ?>
</div>
<?php /**PATH /home/highaltitude/public_html/resources/views/_particles/post/author.blade.php ENDPATH**/ ?>