<?php $__env->startSection("usercontent"); ?>
<h2><?php echo e(trans('index.settings')); ?></h2>
<?php echo $__env->make('errors.adminlook', ['relatedid' => $user->id, 'relatedtext' => trans('index.adminnote')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<div class="setting-form">

    <?php echo Form::open(array('action' => array('UserController@updatesettings', $user->username_slug), 'method' => 'POST', 'enctype' => 'multipart/form-data')); ?>


        <div class="diviner">
            <i class="fa fa-cogs"></i> <?php echo e(trans('index.account')); ?>

        </div>
        <?php if(get_buzzy_config('UserEditUsername')=='yes' or Auth::user()->usertype=='Admin'): ?>
            <div class="form-group">
                <?php echo Form::label('username', trans('index.username')); ?>

                <?php echo Form::text('username', $user->username, ['class' => 'cd-input','id' => 'username']); ?>

            </div>
        <?php endif; ?>
        <?php if(get_buzzy_config('UserEditEmail')=='yes' or Auth::user()->usertype=='Admin'): ?>
            <div class="form-group">
                <?php echo Form::label('email', trans('index.email')); ?>

                <?php echo Form::text('email', Auth::user()->isDemoAdmin() ? 'HIDDEN ON DEMO' : $user->email, ['class' => 'cd-input','id' => 'email']); ?>

               <?php if(get_buzzy_config('UserVerifyEmail')=='yes'): ?>
                <div class="profile-verified">
                <?php if($user->hasVerifiedEmail()): ?>
                <span class="verified"><i class="material-icons">verified</i> <?php echo e(__('This email is verified')); ?></span>
                <?php else: ?>
                 <span class="not_verified"><i class="material-icons">remove_circle_outline</i> <?php echo e(__('Not verified')); ?></span> <a href="<?php echo e(route('verification.notice')); ?>"><?php echo e(__('Click here to verify your email address.')); ?></a>
                <?php endif; ?>
                </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        <div class="form-group">
            <?php echo Form::label('password', trans('index.password')); ?>

            <?php echo Form::text('password', null, ['class' => 'cd-input','id' => 'password', 'placeholder' => trans('index.onlycgange')]); ?>

        </div>

        <div class="form-group">
            <?php echo Form::label('splash', trans('updates.usersplash')); ?>

            <div class="clear"></div>
            <br>
            <input type="file" accept="image/*" id="splash" name="splash">
            <br>
        </div>

        <div class="form-group">
            <?php echo Form::label('icon', trans('updates.useravatar')); ?>

            <div class="clear"></div>
            <img src="<?php echo e(makepreview($user->icon, 'b', 'members/avatar')); ?>" width="200" height="200" class="profile-image">
            <img src="<?php echo e(makepreview($user->icon, 's', 'members/avatar')); ?>" width="90" height="90" class="profile-image">
            <div class="clear"></div>
            <br>
            <input type="file" accept="image/*" id="icon" name="icon">
        </div>
        <div class="diviner">
            <i class="fa fa-user"></i> <?php echo e(trans('index.details')); ?>

        </div>
        <div class="form-group">
            <?php echo Form::label('name', trans('index.fullname')); ?>

            <?php echo Form::text('name', $user->name, ['class' => 'cd-input','id' => 'name']); ?>

        </div>
        <div class="form-group">
            <?php echo Form::label('town', trans('index.location')); ?>

            <?php echo Form::text('town', $user->town, ['class' => 'cd-input','id' => 'town', 'placeholder' => trans('updates.live-in')]); ?>

        </div>
        <div class="form-group">
            <?php echo Form::label('gender', trans('index.gender')); ?>

            <?php echo Form::select('gender', [trans('updates.male') =>trans('updates.male'), trans('updates.female') => trans('updates.female'),  trans('updates.other')=> trans('updates.other')], isset($user->genre) ? $user->genre : null, ['id' => 'gender']); ?>

        </div>

        <div class="form-group">
            <?php echo Form::label('aboutyou', trans('index.about')); ?>

            <?php echo Form::textarea('about', $user->about, ['id' => 'aboutyou', 'placeholder' => trans('updates.abouttext')]); ?>

        </div>

        <?php if(get_buzzy_config('UserAddSocial')=='yes' || Auth::user()->usertype=='Admin'): ?>
            <div class="diviner">
                <i class="fa fa-link"></i>  <?php echo e(trans('index.links')); ?>

            </div>
            <?php ($social_links = collect(config('buzzy.social_links'))->filter(function($item, $provider){
                return !in_array($provider, ['rss'], true );
                })); ?>
            <?php $__currentLoopData = $social_links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $provider => $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="form-group">
                    <?php echo Form::label($provider, $social['name']); ?>

                    <?php echo Form::text('social_profiles['.$provider.']', $user->social_profiles[$provider] ?? null, ['class' => 'cd-input','id' => $provider]); ?>

                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>

        <div class="clear"></div>

        <div>
            <input class="button button-orange button-full" type="submit" value="<?php echo e(trans('index.savesettings')); ?>" >
        </div>
        <br><br>
    <?php echo Form::close(); ?>


</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make("pages.user.userapp", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/highaltitude/public_html/resources/views/pages/user/settings.blade.php ENDPATH**/ ?>