<?php if(get_buzzy_config('p_reactionform') == 'on'): ?>
<section class="user-reactions" id="reactions<?php echo e($post->id); ?>">
    <div class="colheader sea">
        <h3 class="header-title"><?php echo e(trans('updates.reaction.yourreaction')); ?></h3>
    </div>
    <?php
        $most_reactions = \App\ReactionIcon::withCount(['reactions' => function($q) use ($post){
            $q->where('post_id', $post->id);
        }])
        ->byLanguage()
        ->byActive()
        ->orderByDesc('reactions_count')
        ->get();
        $user_reactions = Auth::check() ? $post->reactions()->currentUserHasVoteOnPost($post->id)->pluck('reaction_type')->all() : [];
        $total_votes = $post->reactions()->count();
    ?>
    <div class="clear"></div>
    <div class="percentage-bar">
        <?php $__currentLoopData = $most_reactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php ($reaction_p = $reaction->reactions_count ? number_format(($reaction->reactions_count / $total_votes) * 100, 8) : 0); ?>
        <div class="reaction-emoji">
            <div class="bar">
                <span class="reaction-percent-bar count f" data-percent="<?php echo e($reaction_p); ?>">
                    <span class="count-text"><?php echo e($reaction->reactions_count); ?></span>
                </span>
            </div>
            <a <?php echo get_reaction_user_vote($post, $reaction->reaction_type, $user_reactions); ?>>
                <img alt="<?php echo e($reaction->name); ?>" src="<?php echo e(url($reaction->icon)); ?>" width="50" height="50">
                <span class="text"><?php echo e($reaction->name); ?></span>
            </a>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</section>
<?php endif; ?>
<?php /**PATH /home/highaltitude/public_html/resources/views/_particles/post/reactions.blade.php ENDPATH**/ ?>