<div class="box">
    <div class="box-header with-border">
        <?php if(!isset($feed)): ?>
        <h3 class="box-title"><i class="fa fa-edit"></i>
            <b><?php echo e(trans('v4half.add_new_feed')); ?> </b> </h3>
        <?php else: ?>
        <h3 class="box-title"><i class="fa fa-edit"></i>
            <b><?php echo e(trans('admin.edit')); ?> : <?php echo e($feed->title); ?></b> </h3>
        <?php endif; ?>
        <div class="box-tools pull-right">
            <a href="https://support.akbilisim.com/docs/buzzy/feed-fetcher" target="_blank" class="btn btn-sm btn-success">
                <i class="fa fa-eye mr-5"></i> <?php echo app('translator')->get('v4.see_here_more_info'); ?></a>
        </div>
    </div>
    <?php echo Form::open(array('action' => isset($feed->id) ? 'Admin\FeedController@update' :
    'Admin\FeedController@store', 'method' =>isset($feed->id) ? 'PUT' : 'POST')); ?>

    <?php echo e(csrf_field()); ?>

    <input type="hidden" name="id" value="<?php echo e(isset($feed->id) ? $feed->id : null); ?>">
    <div class="box-body">
        <div class="form-group">
            <label for="add_feed_url" class="cs-label"><?php echo e(trans('v4half.feed_url')); ?></label>
            <?php echo Form::text('url', isset($feed->url) ? $feed->url : old('url'), ['id' => 'add_feed_url',
            'class' => 'form-control input-field mb-2']); ?>

        </div>
        <div class="form-group">
            <label for="add_feed_interval" class="cs-label"><?php echo e(trans('v4half.feed_check_interval')); ?></label>
            <?php echo Form::select('interval', [
            'hourly'=> trans('v4half.hourly'),
            'daily'=> trans('v4half.daily'),
            'weekly'=> trans('v4half.weekly'),
            'monthly'=> trans('v4half.monthly')
            ],
            isset($feed->interval) ? $feed->interval : old('interval') , ['class' => 'form-control input-field
            mb-2']); ?>

        </div>
        <div class="form-group">
            <label for="add_feed_content_fetcher" class="cs-label"><?php echo e(trans('v4half.feed_content_fetcher')); ?></label>
            <?php echo Form::select('content_fetcher', [
            'custom'=> trans('v4half.custom_fetcher'),
            'feed'=> trans('v4half.use_content_from_feed'),
            ],
            isset($feed->content_fetcher) ? $feed->content_fetcher : old('content_fetcher') , ['class' => 'form-control
            input-field
            mb-2']); ?>

        </div>
        <div class="form-group">
            <label for="post_categories" class="cs-label"><?php echo e(trans('v4half.feed_post_categories')); ?></label>
            <select id="post_categories" class="demo-default  mb-2" name="post_categories[]" multiple
                placeholder="<?php echo e(trans('v4half.feed_post_categories')); ?>">
                <?php $__currentLoopData = \App\Category::byMain()->byLanguage()
                ->byActive()
                ->byOrder()
                ->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ci => $categorys): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <optgroup label="">
                    <option value="<?php echo e($categorys->id); ?>"
                        <?php echo e(isset($feed->post_categories) && in_array($categorys->id, explode(',', $feed->post_categories)) ? 'selected' : ''); ?>>
                        <?php echo e($categorys->name); ?></option>
                    <?php $__currentLoopData = $categorys->children()->byActive()
                    ->orderBy('name')
                    ->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($cat->id); ?>"
                        <?php echo e(isset($feed->post_categories) && in_array($cat->id, explode(',', $feed->post_categories))  ? 'selected' : ''); ?>>
                        <b><?php echo e($categorys->name); ?></b> / <?php echo e($cat->name); ?></option>
                    <?php $__currentLoopData = $cat->children()->byActive()
                    ->orderBy('name')
                    ->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $io => $catq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($catq->id); ?>"
                        <?php echo e(isset($feed->post_categories) && in_array($catq->id, explode(',', $feed->post_categories))  ? 'selected' : ''); ?>>
                        <strong><?php echo e($categorys->name); ?></strong> / <b><?php echo e($cat->name); ?></b> /
                        <?php echo e($catq->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </optgroup>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div class="form-group">
            <label for="add_feed_post_users" class="cs-label"><?php echo e(trans('v4half.feed_post_user')); ?></label>
            <?php echo Form::text('post_user_id', null,
            ['class' => '','id' => 'add_feed_post_users', 'placeholder' => trans('v4half.feed_search_post_user')]); ?>

        </div>
        <div class="form-group">
            <label for="add_feed_post_users" class="cs-label"><?php echo e(trans('v4half.feed_post_fetch_count')); ?></label>
            <?php echo Form::number('post_fetch_count', isset($feed->post_fetch_count) ?
            $feed->post_fetch_count : 10,
            [ 'class' => 'form-control input-field mb-2','id' => 'add_feed_post_count']); ?>

        </div>
        <?php if(get_multilanguage_enabled()): ?>
        <div class="form-group">
            <label for="add_menu_item_custom_class" class="cs-label"><?php echo e(trans('v4half.feed_language')); ?></label>
            <?php echo Form::select('language', get_buzzy_language_list_options(), ! empty($feed->language) ?
            $feed->language : get_buzzy_locale() , [
            'id' => 'add_menu_item_language', 'class' => 'form-control input-field mb-2']); ?>

        </div>
        <?php endif; ?>
        <div class="form-group">
            <label for="add_menu_item_custom_class" class="cs-label"><?php echo e(trans('v4half.feed_active')); ?></label>
            <?php echo Form::select('active', [true => trans('admin.yes'), false=>trans('admin.no') ],
            isset($feed->active) ? (bool)$feed->active : true,
            [ 'class' => 'form-control input-field mb-2']); ?>

        </div>
        <div>
            <button type="submit"
                class="btn btn-<?php echo e(isset($feed->id) ? 'success': 'primary'); ?> edit-info"><?php echo e(isset($feed->id) ? trans('v4half.update_feed'): trans('v4half.add_feed')); ?></button>
            <?php if(isset($feed->id)): ?>
            <a href="<?php echo e(route('admin.feeds')); ?>" class="btn btn-default pull-right"><?php echo e(trans('admin.Cancel')); ?></a>
            <?php endif; ?>
        </div>
    </div>
    <?php echo Form::close(); ?>

</div>
<?php /**PATH /home/highaltitude/public_html/resources/views/_admin/pages/feeds/particles/feed-form.blade.php ENDPATH**/ ?>