<?php

/*
|--------------------------------------------------------------------------
| Validation Language Lines
|--------------------------------------------------------------------------
|
| The following language lines contain the default error messages used by
| the validator class. Some of these rules have multiple versions such
| as the size rules. Feel free to tweak each of these messages here.
|
*/

return [
    'accepted'             => 'Το πεδίο :attribute πρέπει να γίνει αποδεκτό.',
    'active_url'           => 'Το πεδίο :attribute δεν είναι αποδεκτή διεύθυνση URL.',
    'after'                => 'Το πεδίο :attribute πρέπει να είναι μία ημερομηνία μετά από :date.',
    'after_or_equal'       => 'Το πεδίο :attribute πρέπει να είναι μία ημερομηνία ίδια ή μετά από :date.',
    'alpha'                => 'Το πεδίο :attribute μπορεί να περιέχει μόνο γράμματα.',
    'alpha_dash'           => 'Το πεδίο :attribute μπορεί να περιέχει μόνο γράμματα, αριθμούς, και παύλες.',
    'alpha_num'            => 'Το πεδίο :attribute μπορεί να περιέχει μόνο γράμματα και αριθμούς.',
    'array'                => 'Το πεδίο :attribute πρέπει να είναι ένας πίνακας.',
    'attached'             => 'Αυτό το :attribute είναι ήδη συνδεδεμένο.',
    'before'               => 'Το πεδίο :attribute πρέπει να είναι μία ημερομηνία πριν από :date.',
    'before_or_equal'      => 'Το πεδίο :attribute πρέπει να είναι μία ημερομηνία ίδια ή πριν από :date.',
    'between'              => [
        'array'   => 'Το πεδίο :attribute πρέπει να έχει μεταξύ :min - :max αντικείμενα.',
        'file'    => 'Το πεδίο :attribute πρέπει να είναι μεταξύ :min - :max kilobytes.',
        'numeric' => 'Το πεδίο :attribute πρέπει να είναι μεταξύ :min - :max.',
        'string'  => 'Το πεδίο :attribute πρέπει να είναι μεταξύ :min - :max χαρακτήρες.',
    ],
    'boolean'              => 'Το πεδίο :attribute πρέπει να είναι true ή false.',
    'confirmed'            => 'Η επιβεβαίωση του :attribute δεν ταιριάζει.',
    'current_password'     => 'The password is incorrect.',
    'date'                 => 'Το πεδίο :attribute δεν είναι έγκυρη ημερομηνία.',
    'date_equals'          => 'Το στοιχείο :attribute πρέπει να είναι μια ημερομηνία, όπως η εξής :date.',
    'date_format'          => 'Το πεδίο :attribute δεν είναι της μορφής :format.',
    'different'            => 'Το πεδίο :attribute και :other πρέπει να είναι διαφορετικά.',
    'digits'               => 'Το πεδίο :attribute πρέπει να είναι :digits ψηφία.',
    'digits_between'       => 'Το πεδίο :attribute πρέπει να είναι μεταξύ :min και :max ψηφία.',
    'dimensions'           => 'Το πεδίο :attribute περιέχει μη έγκυρες διαστάσεις εικόνας.',
    'distinct'             => 'Το πεδίο :attribute περιέχει δύο φορές την ίδια τιμή.',
    'email'                => 'Το πεδίο :attribute πρέπει να είναι μία έγκυρη διεύθυνση email.',
    'ends_with'            => 'Το πεδίο :attribute πρέπει να τελειώνει με ένα από τα παρακάτω: :values.',
    'exists'               => 'Το επιλεγμένο :attribute δεν είναι έγκυρο.',
    'file'                 => 'Το πεδίο :attribute πρέπει να είναι αρχείο.',
    'filled'               => 'To πεδίο :attribute είναι απαραίτητο.',
    'gt'                   => [
        'array'   => 'To πεδίο :attribute πρέπει να έχει περισσότερα από :value αντικείμενα.',
        'file'    => 'To πεδίο :attribute πρέπει να είναι μεγαλύτερο από :value kilobytes.',
        'numeric' => 'To πεδίο :attribute πρέπει να είναι μεγαλύτερο από :value.',
        'string'  => 'To πεδίο :attribute πρέπει να είναι μεγαλύτερο από :value χαρακτήρες.',
    ],
    'gte'                  => [
        'array'   => 'To πεδίο :attribute πρέπει να έχει :value αντικείμενα ή περισσότερα.',
        'file'    => 'To πεδίο :attribute πρέπει να είναι μεγαλύτερο ή ίσο από :value kilobytes.',
        'numeric' => 'To πεδίο :attribute πρέπει να είναι μεγαλύτερο ή ίσο από :value.',
        'string'  => 'To πεδίο :attribute πρέπει να είναι μεγαλύτερο ή ίσο από :value χαρακτήρες.',
    ],
    'image'                => 'Το πεδίο :attribute πρέπει να είναι εικόνα.',
    'in'                   => 'Το επιλεγμένο :attribute δεν είναι έγκυρο.',
    'in_array'             => 'Το πεδίο :attribute δεν υπάρχει σε :other.',
    'integer'              => 'Το πεδίο :attribute πρέπει να είναι ακέραιος.',
    'ip'                   => 'Το πεδίο :attribute πρέπει να είναι μία έγκυρη διεύθυνση IP.',
    'ipv4'                 => 'Το πεδίο :attribute πρέπει να είναι μία έγκυρη διεύθυνση IPv4.',
    'ipv6'                 => 'Το πεδίο :attribute πρέπει να είναι μία έγκυρη διεύθυνση IPv6.',
    'json'                 => 'Το πεδίο :attribute πρέπει να είναι μία έγκυρη συμβολοσειρά JSON.',
    'lt'                   => [
        'array'   => 'To πεδίο :attribute πρέπει να έχει λιγότερα από :value αντικείμενα.',
        'file'    => 'To πεδίο :attribute πρέπει να είναι μικρότερo από :value kilobytes.',
        'numeric' => 'To πεδίο :attribute πρέπει να είναι μικρότερo από :value.',
        'string'  => 'To πεδίο :attribute πρέπει να είναι μικρότερo από :value χαρακτήρες.',
    ],
    'lte'                  => [
        'array'   => 'To πεδίο :attribute δεν πρέπει να υπερβαίνει τα :value αντικείμενα.',
        'file'    => 'To πεδίο :attribute πρέπει να είναι μικρότερo ή ίσο από  :value kilobytes.',
        'numeric' => 'To πεδίο :attribute πρέπει να είναι μικρότερo ή ίσο από :value.',
        'string'  => 'To πεδίο :attribute πρέπει να είναι μικρότερo ή ίσο από  :value χαρακτήρες.',
    ],
    'max'                  => [
        'array'   => 'Το πεδίο :attribute δεν μπορεί να έχει περισσότερα από :max αντικείμενα.',
        'file'    => 'Το πεδίο :attribute δεν μπορεί να είναι μεγαλύτερό :max kilobytes.',
        'numeric' => 'Το πεδίο :attribute δεν μπορεί να είναι μεγαλύτερο από :max.',
        'string'  => 'Το πεδίο :attribute δεν μπορεί να έχει περισσότερους από :max χαρακτήρες.',
    ],
    'mimes'                => 'Το πεδίο :attribute πρέπει να είναι αρχείο τύπου: :values.',
    'mimetypes'            => 'Το πεδίο :attribute πρέπει να είναι αρχείο τύπου: :values.',
    'min'                  => [
        'array'   => 'Το πεδίο :attribute πρέπει να έχει τουλάχιστον :min αντικείμενα.',
        'file'    => 'Το πεδίο :attribute πρέπει να είναι τουλάχιστον :min kilobytes.',
        'numeric' => 'Το πεδίο :attribute πρέπει να είναι τουλάχιστον :min.',
        'string'  => 'Το πεδίο :attribute πρέπει να έχει τουλάχιστον :min χαρακτήρες.',
    ],
    'multiple_of'          => 'Το :attribute πρέπει να είναι πολλαπλάσιο του :value',
    'not_in'               => 'Το επιλεγμένο :attribute δεν είναι αποδεκτό.',
    'not_regex'            => 'Η μορφή του πεδίου :attribute δεν είναι αποδεκτή.',
    'numeric'              => 'Το πεδίο :attribute πρέπει να είναι αριθμός.',
    'password'             => 'Ο κωδικός είναι λανθασμένος.',
    'present'              => 'Το πεδίο :attribute πρέπει να υπάρχει.',
    'prohibited'           => 'Το πεδίο :attribute απαγορεύεται.',
    'prohibited_if'        => 'Το πεδίο :attribute απαγορεύεται όταν το :other είναι :value.',
    'prohibited_unless'    => 'Το πεδίο :attribute απαγορεύεται εκτός αν το :other βρίσκεται στο :values.',
    'regex'                => 'Η μορφή του πεδίου :attribute δεν είναι αποδεκτή.',
    'relatable'            => 'Αυτό το :attribute ενδέχεται να μην σχετίζεται με αυτόν τον πόρο.',
    'required'             => 'Το πεδίο :attribute είναι απαραίτητο.',
    'required_if'          => 'Το πεδίο :attribute είναι απαραίτητο όταν το πεδίο :other είναι :value.',
    'required_unless'      => 'Το πεδίο :attribute είναι απαραίτητο εκτός αν το πεδίο :other εμπεριέχει :values.',
    'required_with'        => 'Το πεδίο :attribute είναι απαραίτητο όταν υπάρχει :values.',
    'required_with_all'    => 'Το πεδίο :attribute είναι απαραίτητο όταν υπάρχουν :values.',
    'required_without'     => 'Το πεδίο :attribute είναι απαραίτητο όταν δεν υπάρχει :values.',
    'required_without_all' => 'Το πεδίο :attribute είναι απαραίτητο όταν δεν υπάρχει κανένα από :values.',
    'same'                 => 'Τα πεδία :attribute και :other πρέπει να είναι ίδια.',
    'size'                 => [
        'array'   => 'Το πεδίο :attribute πρέπει να περιέχει :size αντικείμενα.',
        'file'    => 'Το πεδίο :attribute πρέπει να είναι :size kilobytes.',
        'numeric' => 'Το πεδίο :attribute πρέπει να είναι :size.',
        'string'  => 'Το πεδίο :attribute πρέπει να είναι :size χαρακτήρες.',
    ],
    'starts_with'          => 'Το στοιχείο :attribute πρέπει να ξεκινά με ένα από τα παρακάτω: :values',
    'string'               => 'Το πεδίο :attribute πρέπει να είναι αλφαριθμητικό.',
    'timezone'             => 'Το πεδίο :attribute πρέπει να είναι μία έγκυρη ζώνη ώρας.',
    'unique'               => 'Το πεδίο :attribute έχει ήδη εκχωρηθεί.',
    'uploaded'             => 'Η μεταφόρτωση του πεδίου :attribute απέτυχε.',
    'url'                  => 'Το πεδίο :attribute δεν είναι έγκυρη διεύθυνση URL.',
    'uuid'                 => 'Το πεδίο :attribute πρέπει να είναι έγκυρο UUID.',
    'custom'               => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ],
    'attributes'           => [
        'address'                  => 'Διεύθυνση',
        'age'                      => 'Ηλικία',
        'available'                => 'Διαθέσιμος',
        'city'                     => 'Πόλη',
        'content'                  => 'Περιεχόμενο',
        'country'                  => 'Χώρα',
        'date'                     => 'Ημερομηνία',
        'day'                      => 'Ημέρα',
        'description'              => 'Περιγραφή',
        'email'                    => 'E-mail',
        'excerpt'                  => 'Απόσπασμα',
        'first_name'               => 'Όνομα',
        'gender'                   => 'Γένος',
        'hour'                     => 'Ωρα',
        'last_name'                => 'Επίθετο',
        'message'                  => 'Μήνυμα',
        'minute'                   => 'Λεπτό',
        'mobile'                   => 'Κινητό τηλέφωνο',
        'month'                    => 'Μήνας',
        'name'                     => 'Όνομα',
        'password'                 => 'Συνθηματικό',
        'password_confirmation'    => 'Επιβεβαίωση συνθηματικού',
        'phone'                    => 'Τηλέφωνο',
        'recaptcha_response_field' => 'Η επαλήθευση recaptcha ',
        'second'                   => 'Δευτερόλεπτο',
        'sex'                      => 'Φύλο',
        'size'                     => 'Μέγεθος',
        'subject'                  => 'Θέμα',
        'time'                     => 'Χρόνος',
        'title'                    => 'Τίτλος',
        'username'                 => 'Όνομα χρήστη',
        'year'                     => 'Ετος',
    ],
];
